// wave distortion_hlsl2.vsh

// For now, until NVidia shader problems are resolved
#undef OVERLAP

uniform mat4 vc0;
#define worldViewProj vc0
#ifdef OVERLAP
uniform mat4 vc20;
#define worldViewProjScreen	vc20
#endif

varying vec2 WaveCoords;
varying vec3 WaveTangent;
varying float Factor;
#ifdef OVERLAP
varying vec4 ScreenPos;
#endif

void main()
{
	gl_Position = gl_Vertex * worldViewProj;
	WaveCoords = gl_MultiTexCoord0.st;
	WaveTangent = gl_Normal;
	Factor = gl_MultiTexCoord1.s;

#ifdef OVERLAP
	// Get screen space position of vertex
	ScreenPos = gl_Position * worldViewProjScreen;
#endif
}
